
async function load_accounts() {
    let html = await eel.get_html(type_h='Short')();
    //console.log(html);
    $("#list").empty()
    $("#list").html(html);
    table_mark();
    TranslateInit({lang: "ru",});
}

function success(text) {
    Swal.fire({
        position: 'center',
        icon: 'success',
        title: 'Успех',
        text: text,
        showConfirmButton: false,
        timer: 1900
    })
}

//Код для выделения пунктов в таблице
function table_mark() {
    $('#accounts_from').val(1);
    $('#accounts_before').val($('#table_users >tbody >tr').length);
    
    $('#list >tr').on('click', function () {
        if ($(this).hasClass('bg_selected') == true) {
            $(this).removeClass('bg_selected');
        } else {
            $(this).addClass('bg_selected');
        }
    });

    //Событие нажатия применения диапазона
    $('#accounts_select').on('click', function () {
        //Очищаем выбранные пункты
        clear_selected();

        //Принимаем значения полей от и до
        let from = +$('#accounts_from').val();
        let before = +$('#accounts_before').val();

        //Проверям, чтобы это были числа и они были больше нуля и проверям, чтобы ДО было больше или равно ТО
        if (from > 0 && before > 0 && before >= from) {

            //Запускаем цикл по значениям От и До
            // for (let i = from; i <= before; i++) {
            //     $('#table_users tr').eq(i).addClass('bg_selected');
            // }
            let n = 0
            $('#table_users tr').each(function(){
                if (n >= from && n <= before){
                    $(this).addClass('bg_selected');
                }
                n = n + 1
            });
            // $.each(new Array(before), function(i){
            //     i = i + 1
            //     $('#table_users tr').eq(i).addClass('bg_selected');
            // });
        }

        //Если оба значения пусты - выбираем все пункты
        if (from === '' && before === '') all_selected();
    })

    //Событие нажатия применения диапазона
    $('#accounts_select_free').on('click', function () {
        //Очищаем выбранные пункты
        clear_selected();

        let from = +$('#accounts_from').val();
        let before = +$('#accounts_before').val();

        if (from > 0 && before > 0 && before >= from) {
            let n = 0
            $('#table_users tr').each(function(){
                if (n >= from && n <= before){
                    let hasBadgeSuccess = $(this).find('#status .badge').hasClass('badge-success');
                    if (hasBadgeSuccess) {
                        $(this).addClass('bg_selected');
                    }
                }
                n = n + 1
            });
        }

        if (from === '' && before === '') all_selected();
    })

    //Событие нажатия сброса диапазона
    $('#accounts_deselect').on('click', function () {
        //Очищаем выбранные пункты
        clear_selected();
    })

    //Очищаем все пункты
    function clear_selected() {
        $('#table_users tr').removeClass('bg_selected')
    }

    //Выбераем все пункты
    function all_selected() {
        $('#table_users tr').addClass('bg_selected')
    }
}

$('#delete_accounts').on('click', async function () {
    const result = await Swal.fire({
        title: 'Вы уверены?',
        text: "Вы действительно хотите удалить эти аккаунты?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Да, удалить!',
        cancelButtonText: 'Отменить'
    });
    if (!result.isConfirmed) { return; }
    
    let mass_phone = [];
    //Запускаем цикл по всей таблице
    let mass = $('.bg_selected').children('#phone')
    for (let i = 0; i < mass.length; i++) {
        mass_phone.push(mass[i].textContent);
    }
    await eel.delete_account(mass_phone)();
    success("Аккаунты успешно удаленны!");
    load_accounts();

});

// Передаю номера телефонов массивом
let count_akk = [0, 0];
let module = '';
function get_accounts_list() {
    let accounts_list = [];
    let mass = $('.bg_selected').children('#phone')
    // $.each(new Array(mass.length), function(i){
    //     accounts_list.push(mass[i].textContent);
    // });
    for (let i = 0; i < mass.length; i++) {
         accounts_list.push(mass[i].textContent);
    }
    count_akk[0] = 0;
    count_akk[1] = accounts_list.length;
    return accounts_list;
}

// Проверка аккаунтов
$('#check_accounts').on('click', async function () {
    module = 'check_accounts';
    loader_alert('Проверка аккаунтов', true);
    let accounts_list = get_accounts_list();
    await eel.check_status(accounts_list)();
});

let status_info = [];
eel.expose(result_set);
function result_set(account){
    // console.log(account)
    account = JSON.parse(account);
    let phone = account['phone'];
    let status = account['status'];


    let seter = $('tr:contains("' + phone + '")');

    switch (status) {
        case 'nolimit':
            set_status('Без ограничений', 'badge badge-success p-2')
            break;
        case 'limited':
            set_status('Аккаунт ограничен', 'badge badge-warning p-2')
            break;
        case 'banned':
            set_status('Аккаунт забанен', 'badge badge-danger p-2')
            break;
        case 'None':
            set_status('Ожидает проверки', 'badge badge-info p-2')
            break;
        case 'err_proxy':
            set_status('Ошибка с прокси', 'badge badge-secondary p-2')
            break;
        case 'err_connect':
            set_status('Ошибка подключения', 'badge badge-secondary p-2')
            break;
        case 'err_timeout':
            set_status('Тайм-аут подключения', 'badge badge-secondary p-2')
            break;
        case 'err_json':
            set_status('Некорректный json', 'badge badge-secondary p-2')
            break;
        default:
            if (status && status.includes('limited_time')) {
                text_date = status.split('|')[1]
                set_status('Ограничен до '+text_date, 'badge badge-warning p-2')
                break; 
            }
            if (status && status.includes('freeze_time')) {
                text_date = status.split('|')[1]
                set_status('Заморожен до '+text_date, 'badge badge-warning p-2')
                break; 
            }
            console.log('Ошибка статуса нет в базе!--> ' + status)
    }

    function set_status(text, style_class){
        seter.children('#status').children('span').text(text);
        seter.children('#status').children('span').removeClass();
        seter.children('#status').children('span').addClass(style_class);
    }

    $('#swal2-title').text("Проверено: " + (++count_akk[0]) + ' из ' + count_akk[1]);
    seter.removeClass('bg_selected');
    
    if(module == 'check_accounts'){
        status_info.push({ 'phone': phone, 'status': status })
        // if(count_akk[0] == count_akk[1]){ success_check_accounts() }
    }

}

eel.expose(timeout_check_accounts);
function timeout_check_accounts(){
    $('#table_users tr').removeClass('bg_selected')
    success_check_accounts()
}


let status_banned;
let status_limit;
let status_freeze;
let status_nolimit;
let status_error;
function success_check_accounts() {
    loader_alert('Проверка аккаунтов', false);
    status_nolimit = status_info.filter(function (status_info) {
        return status_info['status'] == 'nolimit';
    });
    status_banned = status_info.filter(function (status_info) {
        return status_info['status'] == 'banned';
    });
    status_freeze = status_info.filter(function (status_info) {
        return status_info['status'].includes('freeze_time');
    });
    status_limit = status_info.filter(function (status_info) {
        return status_info['status'] == 'limited' || status_info['status'].includes('limited_time');
    });
    // status_limit = status_info.filter(function (status_info) {
    //     return status_info['status'] == 'limited';
    // });
    status_error = status_info.filter(function (status_info) {
        return status_info['status'] == 'err_connect';
    });
    $('#verified_accounts').text(status_info.length);
    $('#banned_accounts').text(status_banned.length);
    $('#spamblock_accounts').text(status_limit.length);
    $('#freeze_accounts').text(status_freeze.length);
    $('#free_accounts').text(status_nolimit.length);
    $('#err_connect_accounts').text(status_info.length - status_nolimit.length - status_limit.length - status_freeze.length - status_banned.length);
    //$('#free_accounts').text(status_ok.length);
    $('#check_accounts_modal').modal('show');
    status_info = [];
}

function get_phone(status){
    let phones = status.map(function(phone) {
        return phone['phone']
    });
    return phones
}


//По нажатию применить посылаем запрос на удаление в зависимости от чекбокса
$('#check_accounts_apply').on('click', function () {
    $('#check_accounts_modal').modal('hide');

    if ($('#unload_free_accounts').is(':checked')) {
        res = eel.save_accounts(get_phone(status_nolimit), 'free_accounts')();
    }
    if ($('#unload_banned_accounts').is(':checked')) {
        res = eel.save_accounts(get_phone(status_banned), 'banned_accounts')();
    }
    if ($('#unload_spamblock_accounts').is(':checked')) {
        res = eel.save_accounts(get_phone(status_limit), 'spamblock_accounts')();
    }
    if ($('#unload_freeze_accounts').is(':checked')) {
        res = eel.save_accounts(get_phone(status_freeze), 'freeze_accounts')();
    }
    if ($('#unload_error_accounts').is(':checked')) {
        res = eel.save_accounts(get_phone(status_error), 'error_accounts')();
    }
    // if ($('#delete_free_accounts').is(':checked')) {
    //     res = eel.delete_account(get_phone(status_nolimit))();
    // }
    // if ($('#delete_banned_accounts').is(':checked')) {
    //     res = eel.delete_account(get_phone(status_banned))();
    // }
    // if ($('#delete_spamblock_accounts').is(':checked')) {
    //     res = eel.delete_account(get_phone(status_limit))();
    // }
    // if ($('#delete_error_accounts').is(':checked')) {
    //     res = eel.delete_account(get_phone(status_error))();
    // }
    success("Действия с аккаунтами выполнены!");
    load_accounts();
});