var SPINTAX_PATTERN = /\{[^"\r\n\}]*\}/;
var UserText = ''
var spin = function (spun) {
    var match;
    while (match = spun.match(SPINTAX_PATTERN)) {
        match = match[0];
        var candidates = match.substring(1, match.length - 1).split("|");
        spun = spun.replace(match, candidates[Math.floor(Math.random() * candidates.length)])
    }
    return spun;
}
var spin_countVariations = function (spun) {
    spun = spun.replace(/[^{|}]+/g, '1');
    spun = spun.replace(/\{/g, '(');
    spun = spun.replace(/\|/g, '+');
    spun = spun.replace(/\}/g, ')');
    spun = spun.replace(/\)\(/g, ')*(');
    spun = spun.replace(/\)1/g, ')*1');
    spun = spun.replace(/1\(/g, '1*(');
    return eval(spun);
}

function Spintax(text) {
    var matches, options, random;
    var regEx = new RegExp(/{([^{}]+?)}/);

    while ((matches = regEx.exec(text)) !== null) {
        options = matches[1].split("|");
        random = Math.floor(Math.random() * options.length);
        text = text.replace(matches[0], options[random]);
    }
    return text
}

function changeMask()
{
    ruEN = "{а|a}, {А|A}, {В|B}, {е|e}, {Е|E}, {К|K}, {М|M}, {Н|H}, {о|o}, {О|O}, {р|p}, {Р|P}, {с|c}, {С|C}, {Т|Т}, {х|x}, {Х|X}, {у|y}"
    enRU = "{a|а}, {A|А}, {B|В}, {e|е}, {E|Е}, {K|К}, {M|М}, {H|Н}, {o|о}, {O|О}, {p|р}, {P|Р}, {c|с}, {C|С}, {T|Т}, {x|х}, {X|Х}, {y|у}"
    if ($("[data-tag='maskSwitcher']").prop("checked")) { $("#inputmask").val(enRU) }
    else { $("#inputmask").val(ruEN) }
}

$(document).ready(function () {
    $('#CheckMask').click(function () {
        var temp = Spintax($('#inputmask').val())
        if (temp.indexOf('{') != -1 || temp.indexOf('}') != -1 || temp.indexOf('|') != -1) {
            error('Маска некорректная')
        } else {
            success('Маска корректная')
        }
    });
    
    $('#GenerateNew').click(function () {
        var text = $('#TextField').val()
        $('#NewRandomText').val(Spintax(text))
    })

    $('#GenerateText').click(function () {
        var mask = $('#inputmask').val().split(',')
        var text = $('#TextField').val()

        var temptext = {}
        for (var i = 0; i < mask.length; i++) {
            let minis = mask[i].replace('{', '').replace('}', '').replace(' ', '').split('|')
            if (text.indexOf(minis[0]) != -1) {
                temptext[minis[0]] = mask[i].replace(new RegExp(' '), '')
            }
        }

        $.each(temptext, function (key, value) {
            text = text.replace(new RegExp(key, 'g'), value)

        });

        $('#TextField').val(text)
        $('#NewRandomText').val(Spintax(text))
    })

})


function success(text) {
    Swal.fire({
        position: 'center',
        icon: 'success',
        title: 'Успех',
        text: text,
        showConfirmButton: false,
        timer: 1900
    }).then((result) => { loader_alert('', false) })
}

function error(text) {
    Swal.fire({
        position: 'center',
        icon: 'error',
        title: 'Ошибка',
        text: text,
        showConfirmButton: false,
        timer: 1900
    }).then((result) => { loader_alert('', false) })
}