$('document').ready(function () {

    load_list_proxy()
    async function load_list_proxy() {
        let html = await eel.get_html_proxy()();
        $("#list").empty()
        $("#list").html(html);
        table_mark();
    }
    
    eel.expose(success);
    function success(text) {
        Swal.fire({
            position: 'center',
            icon: 'success',
            title: 'Успех',
            text: text,
            showConfirmButton: false,
            timer: 1900
        }).then((result) => { loader_alert('', false) })
        
    }

    eel.expose(error);
    function error(text) {
        Swal.fire({
            position: 'center',
            icon: 'error',
            title: 'Ошибка',
            text: text,
            showConfirmButton: false,
            timer: 1900
        }).then((result) => { loader_alert('', false) })
    }

    //Сохранение прокси
    $('#save_user_proxy').on('click', async function () {
        let my_proxy = [];
        //Получение данных из textarea
        let lines = $('#textarea_user_proxy').val().split(/\n/);
        //let texts = [];
        for (var i = 0; i < lines.length; i++) {
            if (/\S/.test(lines[i])) {
                my_proxy.push($.trim(lines[i]));
            }
        }
        // console.log(my_proxy) //////////////////////// МАССИВ С ПОЛУЧЕННЫМИ ПРОКСИ
        let type_proxy = $('#type_proxy_select').val();
        // console.log('tup' + type_proxy)
        res = await eel.save_user_proxy(my_proxy, type_proxy)();
        if (res == true) {
            success('Прокси успешно сохранены');
            load_list_proxy();
        }
        else {
            error(res);
            load_list_proxy();
        }
        $('#add_proxy_modal').modal('hide');

    });

    //Удаление прокси
    $('#delete_proxy').on('click', async function () {
        let mass_proxy = [];
        $('#table_proxy tr').each(function(){
            let type_bg = $(this).hasClass("bg_selected");
            if (type_bg == true){
                info_json = $(this).children('#proxy_full').text()
                proxy = JSON.parse(info_json);
                ip = proxy['ip'];
                port = proxy['port'];
                login = proxy['username'];
                password = proxy['password'];
                mass_proxy.push({ 'ip': ip, 'port': port, 'login': login, 'password': password });
            }
        })
        await eel.delete_proxy(mass_proxy)();
        success("Прокси успешно удаленны!");
        load_list_proxy();
    });

    //Удаление прокси
    $('#delete_bed_proxy').on('click', async function () {
        let mass_proxy = [];
        $('#table_proxy tr').each(function(){
            status_dell = $(this).children('#status_proxy').children('span').hasClass("badge-danger")
            if (status_dell == true){
                info_json = $(this).children('#proxy_full').text()
                proxy = JSON.parse(info_json);
                ip = proxy['ip'];
                port = proxy['port'];
                login = proxy['username'];
                password = proxy['password'];
                mass_proxy.push({ 'ip': ip, 'port': port, 'login': login, 'password': password });
            }
        })
        await eel.delete_proxy(mass_proxy)();
        success("Прокси успешно удаленны!");
        load_list_proxy();
    });

    //Удаление всех прокси
    $('#delete_all_proxy').on('click', async function () {
        await eel.delete_all_proxy()();
        success("Все прокси успешно удаленны!");
        load_list_proxy();
    });

    //Удаление прокси
    $('#reset_stat_proxy').on('click', async function () {
        let mass_proxy = [];
        $('#table_proxy tr').each(function(){
            let type_bg = $(this).hasClass("bg_selected");
            if (type_bg == true){
                info_json = $(this).children('#proxy_full').text()
                proxy = JSON.parse(info_json);
                ip = proxy['ip'];
                port = proxy['port'];
                login = proxy['username'];
                password = proxy['password'];
                mass_proxy.push({ 'ip': ip, 'port': port, 'login': login, 'password': password });
            }
        })
        await eel.reset_stat_proxy(mass_proxy)();
        success("Статистика успешно сброшенна!");
        load_list_proxy();
    });

    let count_akk = [0, 0];
    //Запрос на проверку прокси
    $('#check_proxy').on('click', async function () {
        let mass_proxy = [];
        $('#table_proxy tr').each(function(){
            let type_bg = $(this).hasClass("bg_selected");
            if (type_bg == true){
                info_json = $(this).children('#proxy_full').text()
                proxy = JSON.parse(info_json);
                ip = proxy['ip'];
                port = proxy['port'];
                login = proxy['username'];
                password = proxy['password'];
                type_proxy = proxy['proxy_type']
                mass_proxy.push([type_proxy, ip, port, true, login, password]);
            }
        })
        count_akk[0] = 0;
        count_akk[1] = mass_proxy.length;
        loader_alert('Проверка прокси', true)
        await eel.check_proxy(mass_proxy)();
    });

    //Проверка прокси
    eel.expose(check_proxy_set);
    function check_proxy_set(proxy) {
        proxy = JSON.parse(proxy);
        ip = proxy['ip'];
        port = proxy['port'];
        login = proxy['login'];
        password = proxy['password'];
        proxy_status = proxy['status'];

        $('#swal2-title').text("Проверено: " + (++count_akk[0]) + ' из ' + count_akk[1]);

        let seter = $('tr:contains("' + ip + '"):contains("' + port + '"):contains("' + login + '"):contains("' + password + '")');

        switch (proxy_status) {
            case 1:
                set_status('Работает', 'badge badge-success p-2')
                break;
            case 2:
                set_status('Не работает', 'badge badge-danger p-2')
                break;
            case 3:
                set_status('Ожидает проверки', 'badge badge-info p-2')
                break;
            default:
                console.log('Ошибка статуса нет в базе!--> ' + proxy_status)
        }

        function set_status(text, style_class){
            seter.children('#status_proxy').children('span').text(text);
            seter.children('#status_proxy').children('span').removeClass();
            seter.children('#status_proxy').children('span').addClass(style_class);
        }
        seter.removeClass('bg_selected');
        // if(count_akk[0] == count_akk[1]){ success("Прокси успешно проверены!"); }
    }


    window.addEventListener("beforeunload", function (e) {        
        eel.stopped('proxy_checker')
    });

    function table_mark() {
        $('#accounts_from').val(1);
        $('#accounts_before').val($('#table_proxy >tbody >tr').length);

        $('#list >tr').on('click', function () {
            if ($(this).hasClass('bg_selected') == true) {
                $(this).removeClass('bg_selected');
            } else {
                $(this).addClass('bg_selected');
            }
        });

        $('#accounts_select').on('click', function () {
            //Очищаем выбранные пункты
            clear_selected();

            //Принимаем значения полей от и до
            let from = +$('#accounts_from').val();
            let before = +$('#accounts_before').val();

            //Проверям, чтобы это были числа и они были больше нуля и проверям, чтобы ДО было больше или равно ТО
            if (from > 0 && before > 0 && before >= from) {

                //Запускаем цикл по значениям От и До
                // for (let i = from; i <= before; i++) {
                //     $('#table_proxy tr').eq(i).addClass('bg_selected');
                // }

                let n = 0
                $('#table_proxy tr').each(function(){
                    if (n >= from && n <= before){
                        $(this).addClass('bg_selected');
                    }
                    n = n + 1
                });

                // $.each(new Array(before), function(i){
                //     i = i + 1
                //     if (i >= from){
                //         $('#table_proxy tr').eq(i).addClass('bg_selected');
                //     }
                // });
            }

            //Если оба значения пусты - выбираем все пункты
            if (from === '' && before === '') {
                all_selected();
            }
        })

        //Событие нажатия сброса диапазона
        $('#accounts_deselect').on('click', function () {
            //Очищаем выбранные пункты
            clear_selected();
        })

        //Очищаем все пункты
        function clear_selected() {
            $('#table_proxy tr').removeClass('bg_selected')
        }

        //Выбераем все пункты
        function all_selected() {
            $('#table_proxy tr').addClass('bg_selected')
        }
    }
});