
let options = {
    folder_tdata: "",
    type_algo: "UseCurrentSession",
    device_model: ['Desktop'],
    system_version: ['Windows 10', 'Windows 11'],
    app_version: ['4.9.9 x64','4.9.8 x64','4.9.7 x64','4.9.6 x64','4.9.4 x64','4.9.2 x64','4.9.1 x64','4.8.10 x64','4.8.9 x64','4.8.8 x64','4.8.7 x64','4.8.3 x64'],
    lang_code: ['en'],
    system_lang_code: ['en-US','en-RU'],
    app_id_hash: ['2040:b18441a1ff607e10a989891a5462e627']
};

$('#get_settings_history').on('click', async function () {
    $('#device_model').val(localStorage.getItem('device_model_TD'))
    $('#system_version').val(localStorage.getItem('system_version_TD'))
    $('#app_version').val(localStorage.getItem('app_version_TD'))
    $('#lang_code').val(localStorage.getItem('lang_code_TD'))
    $('#system_lang_code').val(localStorage.getItem('system_lang_code_TD'))
    $('#app_id_hash').val(localStorage.getItem('app_id_hash_TD'))
});

$('#settings_reg_save').on('click', async function () {
    options.device_model = get_list_settings($('#device_model').val().split(/\n/));
    options.system_version = get_list_settings($('#system_version').val().split(/\n/));
    options.app_version = get_list_settings($('#app_version').val().split(/\n/));
    options.lang_code = get_list_settings($('#lang_code').val().split(/\n/));
    options.system_lang_code = get_list_settings($('#system_lang_code').val().split(/\n/));
    options.app_id_hash = get_list_settings($('#app_id_hash').val().split(/\n/));
    localStorage.setItem('device_model_TD', $('#device_model').val());
    localStorage.setItem('system_version_TD', $('#system_version').val());
    localStorage.setItem('app_version_TD', $('#app_version').val());
    localStorage.setItem('lang_code_TD', $('#lang_code').val());
    localStorage.setItem('system_lang_code_TD', $('#system_lang_code').val());
    localStorage.setItem('app_id_hash_TD', $('#app_id_hash').val());
    $('#settings_reg_modal').modal('hide');
});

function get_list_settings(lines){
    let settings_list = []
    for (var i = 0; i < lines.length; i++) {
      if (/\S/.test(lines[i])) {
        settings_list.push($.trim(lines[i]));
      }
    }
    return settings_list
}


function get_params_auth(){
    options.device_model = get_list_settings($('#device_model').val().split(/\n/));
    options.system_version = get_list_settings($('#system_version').val().split(/\n/));
    options.app_version = get_list_settings($('#app_version').val().split(/\n/));
    options.lang_code = get_list_settings($('#lang_code').val().split(/\n/));
    options.system_lang_code = get_list_settings($('#system_lang_code').val().split(/\n/));
    options.app_id_hash = get_list_settings($('#app_id_hash').val().split(/\n/));
}

$('#convert_accaunts').on('click', async function () {
    if($('#system_version').val() == '' || $('#app_version').val() == '' || $('#app_id_hash').val() == ''){
        error('Введите настройки для переноса аккаунтов!')
        return
    }

    get_params_auth()

    if ($('#UseCurrentSession').is(':checked')) {
        options.type_algo = 'UseCurrentSession';
    } 
    if ($('#CreateNewSession').is(':checked')) {
        options.type_algo = 'CreateNewSession';
    } 
    
    options.folder_tdata = $('#folder_tdata').val()
    clear_log = 0
    let json = JSON.stringify(options);
    let this_class = $(this).hasClass("btn-success");
    if (this_class == true) {
        $(this).removeClass('btn-success');
        $(this).addClass('btn-danger');
        $(this).text("Остановить");
        $('#log li').remove();
        await eel.converter_tdata_session(json)();
    } else {
        $(this).removeClass('btn-danger');
        $(this).addClass('btn-success');
        $(this).text("Конвертировать аккаунты");
        eel.stopped('converter_tdata_session') //<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< ТУТ КНОПКА ОТМЕНИТЬ
    }

});

eel.expose(set_finished_btn);
function set_finished_btn(){
    $('#convert_accaunts').removeClass('btn-danger');
    $('#convert_accaunts').addClass('btn-success');
    $('#convert_accaunts').text("Конвертировать аккаунты");
}

eel.expose(log);
function log(log_line) {
  if (clear_log == 250){
    $('#log li:first').remove();
  } else {clear_log = clear_log + 1}
  $('#log').append('<li>' + log_line + '</li>');
  $('#log_div').scrollTop($('#log_div')[0].scrollHeight);
}

window.addEventListener("beforeunload", function (e) {        
    eel.stopped('converter_tdata_session')
});
  

function error(text) {
    Swal.fire({
        position: 'center',
        icon: 'error',
        title: 'Ошибка',
        text: text,
        showConfirmButton: false,
        timer: 1900
    })
}