
let options = {
    phone: "",
    device_model: ['Samsung SM-G977B','Samsung SM-G965U1','Samsung SM-T815C','Samsung SM-T815Y','Samsung SM-T819'],
    system_version: ['SDK 31'],
    app_version: ['9.6.6 (33621)','9.6.5 (33539)','9.6.4 (33461)','9.6.3 (33449)','9.6.2 (33411)'],
    lang_code: ['en'],
    system_lang_code: ['en-AM','en-BN','en-IT'],
    app_id_hash: ['4:014b35b6184100b085b0d0572f9b5103'],
    wait_code: "15"
};

$('#get_settings_history').on('click', async function () {
    $('#device_model').val(localStorage.getItem('device_model'))
    $('#system_version').val(localStorage.getItem('system_version'))
    $('#app_version').val(localStorage.getItem('app_version'))
    $('#lang_code').val(localStorage.getItem('lang_code'))
    $('#system_lang_code').val(localStorage.getItem('system_lang_code'))
    $('#app_id_hash').val(localStorage.getItem('app_id_hash'))
    $('#wait_code').val(localStorage.getItem('wait_code'))
});

$('#settings_reg_save').on('click', async function () {
    options.device_model = get_list_settings($('#device_model').val().split(/\n/));
    options.system_version = get_list_settings($('#system_version').val().split(/\n/));
    options.app_version = get_list_settings($('#app_version').val().split(/\n/));
    options.lang_code = get_list_settings($('#lang_code').val().split(/\n/));
    options.system_lang_code = get_list_settings($('#system_lang_code').val().split(/\n/));
    options.app_id_hash = get_list_settings($('#app_id_hash').val().split(/\n/));
    options.wait_code = $('#wait_code').val();

    localStorage.setItem('device_model', $('#device_model').val());
    localStorage.setItem('system_version', $('#system_version').val());
    localStorage.setItem('app_version', $('#app_version').val());
    localStorage.setItem('lang_code', $('#lang_code').val());
    localStorage.setItem('system_lang_code', $('#system_lang_code').val());
    localStorage.setItem('app_id_hash', $('#app_id_hash').val());
    localStorage.setItem('wait_code', $('#wait_code').val());
    $('#settings_reg_modal').modal('hide');
});

function get_list_settings(lines){
    let settings_list = []
    for (var i = 0; i < lines.length; i++) {
      if (/\S/.test(lines[i])) {
        settings_list.push($.trim(lines[i]));
      }
    }
    return settings_list
}

eel.expose(get_add_code);
function get_add_code(){
    $('#auth_code_form').removeClass('d-none');
    return $('#auth_code').val()
}

eel.expose(get_two_fa);
function get_two_fa(){
    $('#two_fa_form').removeClass('d-none');
    return $('#two_fa').val()
}

function get_params_auth(){
    options.device_model = get_list_settings($('#device_model').val().split(/\n/));
    options.system_version = get_list_settings($('#system_version').val().split(/\n/));
    options.app_version = get_list_settings($('#app_version').val().split(/\n/));
    options.lang_code = get_list_settings($('#lang_code').val().split(/\n/));
    options.system_lang_code = get_list_settings($('#system_lang_code').val().split(/\n/));
    options.app_id_hash = get_list_settings($('#app_id_hash').val().split(/\n/));
    options.wait_code = $('#wait_code').val();
}

$('#add_accaunt').on('click', async function () {
    if($('#system_version').val() == '' || $('#app_version').val() == '' || $('#app_id_hash').val() == ''){
        error('Введите настройки для переноса аккаунтов!')
        return
    }

    get_params_auth()
    
    options.phone = $('#phone').val()
    let json = JSON.stringify(options);
    let this_class = $(this).hasClass("btn-success");
    if (this_class == true) {
        $(this).removeClass('btn-success');
        $(this).addClass('btn-danger');
        $(this).text("Остановить");
        $('#log li').remove();
        await eel.transfer_accounts(json)();
    } else {
        $(this).removeClass('btn-danger');
        $(this).addClass('btn-success');
        $(this).text("Добавить аккаунт");
        eel.stopped('transfer_acc') //<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< ТУТ КНОПКА ОТМЕНИТЬ
    }

});

eel.expose(set_finished_btn);
function set_finished_btn(){
    $('#add_accaunt').removeClass('btn-danger');
    $('#add_accaunt').addClass('btn-success');
    $('#add_accaunt').text("Добавить аккаунт");
    $('#auth_code_form').addClass('d-none');
    $('#two_fa_form').addClass('d-none');
    $('#auth_code').val('')
    $('#two_fa').val('')
}

eel.expose(log);
function log(log_line) {
    $('#log').append('<li>' + log_line + '</li>');
    $('#log_div').scrollTop($('#log_div')[0].scrollHeight);
    $(".spinner-grow").remove();
    $("li").last().append('<div class="spinner-grow spinner-grow-sm ml-1 mb-1"></div>');  
}

window.addEventListener("beforeunload", function (e) {        
    eel.stopped('transfer_acc')
});
  

function error(text) {
    Swal.fire({
        position: 'center',
        icon: 'error',
        title: 'Ошибка',
        text: text,
        showConfirmButton: false,
        timer: 1900
    })
}