
$('document').ready(function () {

    //Функция выгрузки аккаунтов
    load_accounts();
    async function load_accounts() {
        console.time('FirstWay');
        $('#table_load').removeClass('d-none');
        let html = await eel.get_html()();
        console.timeEnd('FirstWay');
        //console.log(html);
        $("#list").empty()
        $("#list").html(html);
        $('#table_load').addClass('d-none');
        // auto_chek_status();
        table_mark();
        TranslateInit({lang: "ru",});
    }

    //Функция которая вызывает окно успеха
    eel.expose(success);
    function success(text) {
        Swal.fire({
            position: 'center',
            icon: 'success',
            title: 'Успех',
            text: text,
            showConfirmButton: false,
            timer: 1900
        }).then((result) => { loader_alert('', false) })
    }
    //Функция которая вызывает окно ошибки
    eel.expose(error);
    function error(text) {
        Swal.fire({
            position: 'center',
            icon: 'error',
            title: 'Ошибка',
            text: text,
            showConfirmButton: false,
            timer: 1900
        }).then((result) => { loader_alert('', false) })
    }

    // Передаю номера телефонов массивом
    let count_akk = [0, 0];
    let module = '';
    function get_accounts_list(text) {
        $('#panel_buttons button').attr('disabled', true);
        $('#panel_buttons button').css('opacity', '1');  
        let accounts_list = [];
        let mass = $('.bg_selected').children('#phone')
        for (let i = 0; i < mass.length; i++) {
             accounts_list.push(mass[i].textContent);
        }
        count_akk[0] = 0;
        count_akk[1] = accounts_list.length;
        if(accounts_list.length != 0){
            loader_alert(text, true);
        }
        setTimeout(()=>{$('#panel_buttons button').attr('disabled', false);}, 2000);
        if (accounts_list.length == 0){
            error('Вы не выбрали аккаунты!')
            return False
        }
        return accounts_list;
    }



    // Проверка аккаунтов
    $('#check_accounts').on('click', async function () {
        module = 'check_accounts';
        let accounts_list = get_accounts_list('Проверка аккаунтов');
        await eel.check_status(accounts_list)();
    });

    // Проверка аккаунтов 
    $('#check_accounts_nobot').on('click', async function () {
        module = 'check_accounts';
        let accounts_list = get_accounts_list('Проверка без @SpamBot');
        await eel.check_status_nobot(accounts_list)();
    });

    // Обновить информацию об аккаунтах
    $('#update_accounts_details').on('click', async function () {
        module = 'update_accounts_details';
        let accounts_list = get_accounts_list('Обновление данных');
        await eel.update_accounts_details(accounts_list)();
    });

    // Установить случайные фото
    $('#add_random_photo').on('click', async function () {
        module = 'add_random_photo';
        $('#add_photo_accounts_modal').modal('hide');
        let accounts_list = get_accounts_list('Установка фото');
        await eel.set_ava({ 'account': accounts_list, 'delete': 0 })();
    });

    // Установить свои фото
    $('#add_my_photo').on('click', async function () {
        module = 'add_my_photo';
        let name_photo = await eel.first_click_upload()();
        if (name_photo === false){ return false }
        $('#add_photo_accounts_modal').modal('hide');
        let accounts_list = get_accounts_list('Установка фото');
        await eel.set_ava({ 'account': accounts_list, 'avatar': name_photo, 'delete': 0 })();
    });


    $('#delete_all_photo').on('click', async function () {
        module = 'add_random_photo';
        $('#add_photo_accounts_modal').modal('hide');
        let accounts_list = get_accounts_list('Удаление фото');
        await eel.set_ava({ 'account': accounts_list, 'delete': 1 })();
    });

    // Установить статусы "о себе"
    $('#bio_accounts_apply').on('click', async function () {
        module = 'bio_accounts_apply';
        $('#bio_accounts_modal').modal('hide');
        let bio_accounts_text = $('#bio_accounts_modal_input').val();
        let accounts_list = get_accounts_list('Установка статусов');
        await eel.set_one_status_about(accounts_list, bio_accounts_text)();
    });

    // Установить свои именна
    $('#add_new_name_apply').on('click', async function () {
        module = 'add_new_name_apply';
        $('#add_new_name_accounts_modal').modal('hide');
        let accounts_list = get_accounts_list('Установка имен');
        let name_accounts_text = $('#my_name_modal_input').val();
        let lastname_modal_input = $('#my_lastname_modal_input').val();
        await eel.set_name(accounts_list, name_accounts_text, lastname_modal_input)();
    });

    // Установить рандомные имена RU
    $('#add_random_name_ru').on('click', async function () {
        module = 'add_random_name';
        $('#add_new_name_accounts_modal').modal('hide');
        let accounts_list = get_accounts_list('Установка имен');
        await eel.set_name_rand(accounts_list, 'ru')();
    });

    // Установить рандомные имена EN
    $('#add_random_name_en').on('click', async function () {
        module = 'add_random_name';
        $('#add_new_name_accounts_modal').modal('hide');
        let accounts_list = get_accounts_list('Установка имен');
        await eel.set_name_rand(accounts_list, 'en')();
    });

    // Установить @username
    $('#add_random_username').on('click', async function () {
        module = 'add_random_username';
        $('#add_username_accounts_modal').modal('hide');
        let accounts_list = get_accounts_list('Установка @username');
        await eel.set_username(accounts_list, module)();
    });

    // Установить свои @username
    $('#add_my_username_accounts_apply').on('click', async function () {
        module = 'add_my_username_accounts_apply';
        $('#add_my_username_accounts_modal').modal('hide');
        let my_username_text = $('#add_my_username_accounts_input').val();
        let accounts_list = get_accounts_list('Установка @username');
        await eel.set_my_username(accounts_list, my_username_text)();
    });

    // Удалить @username
    $('#dell_all_username').on('click', async function () {
        module = 'dell_all_username';
        $('#add_username_accounts_modal').modal('hide');
        let accounts_list = get_accounts_list('Удаление @username');
        await eel.set_username(accounts_list, module)();
    });

    // Установить пола
    $('.add_my_sex').on('click', async function () {
        module = 'add_my_sex';
        $('#add_sex_accounts_modal').modal('hide');
        let accounts_list = get_accounts_list('Установка');
        let sex_type = $(this).attr('sex');
        await eel.set_sex_accaunt(accounts_list, sex_type)();
    });

    // Удалить все контакты
    $('#delete_all_contact').on('click', async function () {
        module = 'delete_all_contact';
        let accounts_list = get_accounts_list('Очистка');
        await eel.delete_all_contact(accounts_list)();
    });

    // Очистить диалоги
    $('#clear_user_dialog').on('click', async function () {
        module = 'clear_user_dialog';
        let accounts_list = get_accounts_list('Очистка');
        await eel.clear_chats(accounts_list, module)();
    });

    // Очистить диалоги
    $('#leave_chat').on('click', async function () {
        module = 'leave_chat';
        let accounts_list = get_accounts_list('Очистка');
        await eel.clear_chats(accounts_list, module)();
    });

    // Очистить диалоги
    $('#remove_all_session').on('click', async function () {
        module = 'remove_all_session';
        let accounts_list = get_accounts_list('Сброс');
        await eel.remove_sessions(accounts_list)();
    });
    
    // Установить свой 2fa
    $('#2fa_pass_apply').on('click', async function () {
        module = 'twoFa_my_pass';
        $('#set2fa_accounts_modal').modal('hide');
        let accounts_list = get_accounts_list('Установка');
        let pass_text = $('#2fa_pass_modal_input').val();
        await eel.twoFa_accaunts(accounts_list, module, pass_text)();
    });

    // Установить случайный 2fa
    $('#add_random_2fa_pass').on('click', async function () {
        module = 'twoFa_random';
        $('#set2fa_accounts_modal').modal('hide');
        let accounts_list = get_accounts_list('Установка');
        await eel.twoFa_accaunts(accounts_list, module)();
    });

    // Удалить 2fa
    $('#dell_2fa_pass').on('click', async function () {
        module = 'twoFa_dell';
        $('#set2fa_accounts_modal').modal('hide');
        let accounts_list = get_accounts_list('Установка');
        await eel.twoFa_accaunts(accounts_list, module)();
    });

    // Скрыть номера телефонов
    $('#hidden_phone_number').on('click', async function () {
        module = 'hidden_phone_number';
        let accounts_list = get_accounts_list('Установка');
        await eel.hidden_phone_accaunts(accounts_list)();
    });

    // Проверить дату создания аккаунтов
    $('.date_creation_accaunt').on('click', async function () {
        module = 'date_creation_accaunt';
        $('#date_creation_accaunt_modal').modal('hide');
        let accounts_list = get_accounts_list('Проверка');
        await eel.date_creation_accaunt_check(accounts_list)();
    });

    // Скрыть последнюю активность
    $('.add_my_hidden_activity').on('click', async function () {
        module = 'hidden_activity';
        $('#hidden_activity_modal').modal('hide');
        let accounts_list = get_accounts_list('Установка');
        let status_type = $(this).attr('status');
        await eel.hidden_activity_accaunts(accounts_list, status_type)();
    });

    // Запрет на добавление аккаунтов в группы
    $('.add_my_disable_adding').on('click', async function () {
        module = 'disable_adding';
        $('#disable_adding_modal').modal('hide');
        let accounts_list = get_accounts_list('Установка');
        let status_type = $(this).attr('status');
        await eel.disable_adding_accaunts(accounts_list, status_type)();
    });

    let status_info = [];
    eel.expose(result_set);
    function result_set(account_info){
        // console.log(account_info)
        account = JSON.parse(account_info);
        try {
            let phone = account['phone'];
            if (phone === undefined || phone === null || phone === '') { phone = account['session_file']; }
            let photo = account['avatar'];
            let username = account['username'];
            let first_name = account['first_name'];
            let last_name = account['last_name'];
            let register_time = account['register_time'];
            let sex = account['sex'];
            let status = account['status'];
            let proxy = account['proxy'];

            // console.log(phone, photo, username, first_name, last_name, register_time, sex, status, proxy)
            let seter = $('tr:contains("' + phone + '")');
            // console.log(status)
            switch (status) {
                case 'nolimit':
                    set_status('Без ограничений', 'badge badge-success p-2')
                    break;
                case 'limited':
                    set_status('Аккаунт ограничен', 'badge badge-warning p-2')
                    break;
                case 'banned':
                    set_status('Аккаунт забанен', 'badge badge-danger p-2')
                    break;
                case 'None':
                    set_status('Ожидает проверки', 'badge badge-info p-2')
                    break;
                case 'err_proxy':
                    set_status('Ошибка с прокси', 'badge badge-secondary p-2')
                    break;
                case 'err_connect':
                    set_status('Ошибка подключения', 'badge badge-secondary p-2')
                    break;
                case 'err_timeout':
                    set_status('Тайм-аут подключения', 'badge badge-secondary p-2')
                    break;
                case 'err_json':
                    set_status('Некорректный json', 'badge badge-secondary p-2')
                    break;
                default:
                    if (status && status.includes('limited_time')) {
                        text_date = status.split('|')[1]
                        set_status('Ограничен до '+text_date, 'badge badge-warning p-2')
                        break; 
                    }
                    if (status && status.includes('freeze_time')) {
                        text_date = status.split('|')[1]
                        set_status('Заморожен до '+text_date, 'badge badge-warning p-2')
                        break; 
                    }
                    console.log('Ошибка статуса нет в базе!--> ' + status)
            }

            function set_status(text, style_class){
                seter.children('#status').children('span').text(text);
                seter.children('#status').children('span').removeClass();
                seter.children('#status').children('span').addClass(style_class);
            }

            let ip = proxy[1];
            let port = proxy[2];
            if (proxy == 'null' || proxy == 'None' || ip == undefined) {
                seter.children('#proxy').text("-----");
            } else {
                port = port.toString()
                seter.children('#proxy').text(ip + ':' + port.slice(0,6))
            };

            seter.children('#photo').children('img').attr('src', photo);

            if (register_time == 'null' || register_time == 'None' || register_time == null) {
                seter.children('#register_time').text("-----");
            } else {
                seter.children('#register_time').text(register_time);
            }

            if(sex == '0'){
                seter.children('#sex').html('<i class="fas fa-venus" style="font-size: 1.5em; color: #F31E12c7"></i>');
            } else if (sex == '1'){
                seter.children('#sex').html('<i class="fas fa-mars" style="font-size: 1.5em; color: #007CF5c7"></i>');
            } else {
                seter.children('#sex').text("-----");
            }

            if (first_name == 0) {
                seter.children('#name').text("-----");
            } else {
                if(last_name == "None"){
                    seter.children('#name').text(first_name);
                } else{
                    seter.children('#name').text(first_name + ' ' + last_name);
                }
            }

            if (username == 0 || username == 'None' || username == 'Null' || username == null) {
                seter.children('#username').text("-----");
            } else {
                seter.children('#username').text('@' + username);
            }

            $('#swal2-title').text("Обработано: " + (++count_akk[0]) + ' из ' + count_akk[1]);
            seter.removeClass('bg_selected');
            
            if(module == 'check_accounts'){
                status_info.push({ 'phone': phone, 'status': status })
                // if(count_akk[0] == count_akk[1]){ success_check_accounts() }
            } else if (module == 'add_random_photo' || module == 'add_my_photo'){ //Случайные фото установленны! | Ваши фото установленны!
                if(count_akk[0] == count_akk[1]){ success('Фотографии установленны!') }
            } else if (module == 'update_accounts_details'){
                if(count_akk[0] == count_akk[1]){ success('Данные обновлены!') }
            } else if (module == 'bio_accounts_apply'){
                if(count_akk[0] == count_akk[1]){ success('Cтатусы "О себе" установленны!') }
            } else if (module == 'add_new_name_apply' || module == 'add_random_name'){ //Свои имена установленны! | Случайные имена установленны!
                if(count_akk[0] == count_akk[1]){ success('Имена установленны!') }
            } else if (module == 'add_random_username' || module == 'dell_all_username' || module == 'add_my_username_accounts_apply'){
                if(count_akk[0] == count_akk[1]){ success('@username установленны!') }
            } else if (module == 'add_my_sex'){
                if(count_akk[0] == count_akk[1]){ success('Пол для аккаунтов установлен!') }
            } else if (module == 'delete_all_contact'){
                if(count_akk[0] == count_akk[1]){ success('Все контакты удалены!') }
            } else if (module == 'clear_user_dialog' || module == 'leave_chat'){
                if(count_akk[0] == count_akk[1]){ success('Диалоги очищены!') }
            } else if (module == 'remove_all_session'){
                if(count_akk[0] == count_akk[1]){ success('Сторонние сессии сброшены!') }
            } else if (module == 'hidden_phone_number'){
                if(count_akk[0] == count_akk[1]){ success('Номера на аккаунтах скрыты!') }
            } else if (module == 'date_creation_accaunt'){
                if(count_akk[0] == count_akk[1]){ success('Аккаунты проверены!') }
            } else if (module == 'hidden_activity'){
                if(count_akk[0] == count_akk[1]){ success('Установлен статус приватности!') }
            } else if (module == 'disable_adding'){
                if(count_akk[0] == count_akk[1]){ success('Установлен статус приватности!') }
            } else if (module == 'twoFa_my_pass' || module == 'twoFa_random' || module == 'twoFa_dell'){
                if(count_akk[0] == count_akk[1]){ success('2fa установлен!') }
            }
        } catch (err) {
            console.log("==========================================")
            console.log(err)
            console.log(account_info)
            console.log("==========================================")
        }
    }


    eel.expose(timeout_check_accounts);
    function timeout_check_accounts(){
        $('#table_users tr').removeClass('bg_selected')
        success_check_accounts()
    }

    let status_banned;
    let status_limit;
    let status_freeze;
    let status_nolimit;
    let status_error;
    function success_check_accounts() {
        loader_alert('Проверка аккаунтов', false);
        status_nolimit = status_info.filter(function (status_info) {
            return status_info['status'] == 'nolimit';
        });
        status_banned = status_info.filter(function (status_info) {
            return status_info['status'] == 'banned';
        });
        status_freeze = status_info.filter(function (status_info) {
            return status_info['status'].includes('freeze_time');
        });
        status_limit = status_info.filter(function (status_info) {
            return status_info['status'] == 'limited' || status_info['status'].includes('limited_time');
        });
        // status_limit = status_info.filter(function (status_info) {
        //     return status_info['status'] == 'limited';
        // });
        status_error = status_info.filter(function (status_info) {
            return status_info['status'] == 'err_connect';
        });
        $('#verified_accounts').text(status_info.length);
        $('#banned_accounts').text(status_banned.length);
        $('#spamblock_accounts').text(status_limit.length);
        $('#freeze_accounts').text(status_freeze.length);
        $('#free_accounts').text(status_nolimit.length);
        $('#err_connect_accounts').text(status_info.length - status_nolimit.length - status_limit.length - status_freeze.length - status_banned.length);
        //$('#free_accounts').text(status_ok.length);
        $('#check_accounts_modal').modal('show');
        status_info = [];
    }

    function get_phone(status){
        let phones = status.map(function(phone) {
            return phone['phone']
        });
        return phones
    }


    //По нажатию применить посылаем запрос на удаление в зависимости от чекбокса
    $('#check_accounts_apply').on('click', function () {
        $('#check_accounts_modal').modal('hide');

        if ($('#unload_free_accounts').is(':checked')) {
            res = eel.save_accounts(get_phone(status_nolimit), 'free_accounts')();
        }
        if ($('#unload_banned_accounts').is(':checked')) {
            res = eel.save_accounts(get_phone(status_banned), 'banned_accounts')();
        }
        if ($('#unload_spamblock_accounts').is(':checked')) {
            res = eel.save_accounts(get_phone(status_limit), 'spamblock_accounts')();
        }
        if ($('#unload_freeze_accounts').is(':checked')) {
            res = eel.save_accounts(get_phone(status_freeze), 'freeze_accounts')();
        }
        if ($('#unload_error_accounts').is(':checked')) {
            res = eel.save_accounts(get_phone(status_error), 'error_accounts')();
        }
        // if ($('#delete_free_accounts').is(':checked')) {
        //     res = eel.delete_account(get_phone(status_nolimit))();
        // }
        // if ($('#delete_banned_accounts').is(':checked')) {
        //     res = eel.delete_account(get_phone(status_banned))();
        // }
        // if ($('#delete_spamblock_accounts').is(':checked')) {
        //     res = eel.delete_account(get_phone(status_limit))();
        // }
        // if ($('#delete_error_accounts').is(':checked')) {
        //     res = eel.delete_account(get_phone(status_error))();
        // }
        success("Действия с аккаунтами выполнены!");
        load_accounts();
    });
    
    //Удаление аккаунтов
    $('#delete_accounts').on('click', async function () {
        const result = await Swal.fire({
            title: 'Вы уверены?',
            text: "Вы действительно хотите удалить эти аккаунты?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Да, удалить!',
            cancelButtonText: 'Отменить'
        });
        if (!result.isConfirmed) { return; }

        let mass_phone = [];
        $('#table_users tr').each(function(){
            let type_bg = $(this).hasClass("bg_selected");
            if (type_bg == true){
                phone_user = $(this).children('#phone').html();
                mass_phone.push(phone_user);
            }
        });

        await eel.delete_account(mass_phone)();
        success("Аккаунты успешно удаленны!");
        load_accounts();
    });

    // function delete_acc_table(mass_phone){
    //     for (let i = 0; i <= mass_phone.length; i++) {
    //         let seter = $('tr:contains("' + mass_phone[i] + '")');
    //         seter.remove();
    //     }
    //     location.reload();
    // }

    //Сброс прокси
    $('#remove_proxy').on('click', async function () {
        let mass_phone = [];
        $('#table_users tr').each(function(){
            let type_bg = $(this).hasClass("bg_selected");
            if (type_bg == true){
                phone_user = $(this).children('#phone').html();
                mass_phone.push(phone_user);
                $(this).children('#proxy').text("-----");
                $(this).removeClass('bg_selected')
            }
        });

        await eel.reset_proxy(mass_phone)();
        success("Прокси успешно сброшены!");
        // load_accounts();
        // location.reload();

    });

    //Сохранение аккаунтов в папку Архив
    $('#save_accounts_archive').on('click', async function () {
        let mass_phone = [];
        $('#table_users tr').each(function(){
            let type_bg = $(this).hasClass("bg_selected");
            if (type_bg == true){
                phone_user = $(this).children('#phone').html();
                mass_phone.push(phone_user);
            }
        });

        await eel.save_accounts(mass_phone, 'archive')();
        // await eel.delete_account(mass_phone)();
        success("Аккаунты успешно выгружены из базы!");
        load_accounts();
        // location.reload();
        $('#manager_accounts_modal').modal('hide');
    });

    //Сохранение аккаунтов в свою папку
    $('#save_accounts_tag').on('click', async function () {
        let mass_phone = [];
        $('#table_users tr').each(function(){
            let type_bg = $(this).hasClass("bg_selected");
            if (type_bg == true){
                phone_user = $(this).children('#phone').html();
                mass_phone.push(phone_user);
            }
        });

        // 
        let save_accounts_tag = $('#save_accounts_tag_input').val();

        await eel.save_accounts(mass_phone, save_accounts_tag)();
        // await eel.delete_account(mass_phone)();
        success("Аккаунты успешно выгружены из базы!");
        load_accounts();
        // location.reload();
        $('#manager_accounts_modal').modal('hide');
    });

    //Получение кода авторизации

    $('#get_kod_accounts').on('click', function () {
        $('#get_kod_accounts_modal').modal('show');
        let res = '';
        let mass_phone_code = [];
        //Запускаем цикл по всей таблице
        $('#table_users tr').each(function(){
            let type_bg = $(this).hasClass("bg_selected");
            if (type_bg == true){
                phone_user = $(this).children('#phone').html();
                mass_phone_code.push(phone_user);
                $(this).removeClass('bg_selected');
            }
        });
        let i = 0;
        $('#kod_phone_accounts').text("+***********");
        get_code();
        function get_code() {
            $('#kod_phone_accounts').text(mass_phone_code[i]);
        }
        $('#get_kod_accounts_modal').on('hidden.bs.modal', function () {
            mass_phone_code = [];
            $('#received_kod').text("*****");
            // get_code();
        })
        $('#get_kod_button').on('click', async function () {
            $(this).attr('disabled', true); 
            res = await eel.get_code_autorisation(mass_phone_code[i])();
            $('#received_kod').text(res);
            $(this).attr('disabled', false);
        })
        $('#next_phone_get_kod').on('click', function () {
            i++;
            if (i == mass_phone_code.length) {
                mass_phone_code = [];
                i = 0;
                $('#get_kod_accounts_modal').modal('hide');
            }
            $('#received_kod').text("*****");
            get_code();
        })

    });


    function filter_table(){
        table_mark()
        $.each($("#table_users tbody tr"), function() {
            if($(this).text().toLowerCase().indexOf($('#search').val().toLowerCase()) === -1) {
                $(this).removeClass('bg_selected');
            } else if ($('#search').val() === '') {
                $(this).removeClass('bg_selected');
            }
            else {
                $(this).addClass('bg_selected');                
            }
        });
    }

    $("#search").keyup(function(){
        filter_table()
        table_mark()
    });


    $('#search_button').on('click', function () {
        let this_class = $('#search_table').hasClass("d-none");
        if (this_class == true) {
            $('#search_table').removeClass('d-none');
        } else {
            $('#search_table').addClass('d-none');
        }
    })

    //Код для выделения пунктов в таблице
    function table_mark() {
        $('#accounts_from').val(1);
        $('#accounts_before').val($('#table_users >tbody >tr').length);
        $('#accounts_from').attr("placeholder", "от (1)");
        $('#accounts_before').attr("placeholder", "до (" + $('#table_users >tbody >tr').length + ")");

        $('#list >tr').on('click', function () {
            if ($(this).hasClass('bg_selected') == true) {
                $(this).removeClass('bg_selected');
            } else {
                $(this).addClass('bg_selected');
            }
        });

        //Событие нажатия применения диапазона
        $('#accounts_select').on('click', function () {
            //Очищаем выбранные пункты
            clear_selected();

            //Принимаем значения полей от и до
            let from = +$('#accounts_from').val();
            let before = +$('#accounts_before').val();

            //Проверям, чтобы это были числа и они были больше нуля и проверям, чтобы ДО было больше или равно ТО
            if (from > 0 && before > 0 && before >= from) {

                let n = 0
                $('#table_users tr').each(function(){
                    if (n >= from && n <= before){
                        $(this).addClass('bg_selected');
                    }
                    n = n + 1
                });

            }

            //Если оба значения пусты - выбираем все пункты
            console.log(from, before)
            if (from === 0 && before === 0) {
                all_selected();
            }
        })

        //Событие нажатия сброса диапазона
        $('#accounts_deselect').on('click', function () {
            //Очищаем выбранные пункты
            $("#search").val('');
            // filter_table()
            clear_selected();
        })

        //Очищаем все пункты
        function clear_selected() {
            $('#table_users tr').removeClass('bg_selected')
            // table_mark()
        }

        //Выбераем все пункты
        function all_selected() {
            $('#table_users tr').addClass('bg_selected')
        }
    }



});

eel.expose(reload_front);
async function reload_front(text) {
    await load_accounts()()
}